/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#include "CommandPackager.h"

CommandPackager::CommandPackager () { }

CommandPackager::~CommandPackager () { }

char * CommandPackager::buildPackage(commPackage *cpack, int& nlen) {

    char *msg = NULL;

    switch(cpack->tc) {
        case OPEN:
            nlen = 3 + strlen(cpack->name) + 1;
            msg = new char[nlen];
            msg[0] = (unsigned char) OPEN;
            msg[1] = (unsigned char) cpack->usbin;
            msg[2] = (unsigned char) cpack->usbout;
            for (int i=0; i < (nlen-3); i++) {
                msg[i+3] = cpack->name[i];
            };
            msg[nlen] = (char)('\0');
            break;
        case CLOSE:
            nlen = 2;
            msg = new char[nlen];
            msg[0] = (unsigned char) CLOSE;
            msg[1] = (unsigned char) cpack->hnd;
            break;
        case MESSAGE:
            break;
        case LOAD:
            break;
        case UNLOAD:
            break;
        case MODULE_QTY:
            nlen = 1;
            msg = new char[nlen];
            msg[0] = (unsigned char) MODULE_QTY;
            break;
        case MODULE_NAME:
            nlen = 2;
            msg = new char[nlen];
            msg[0] = (unsigned char) MODULE_NAME;
            msg[1] = (unsigned char) cpack->index;
            break;
        case INIT:
            nlen = 1;
            msg = new char[nlen];
            msg[0] = (unsigned char) INIT;
            break;
        case CONFIGURE:
            break;
        case NOTHING:
            break;
    };
    return msg;
}

commPackage* CommandPackager::unbuildPackage(char *msg, int len) {

    commPackageResponse *cpackres;
    commPackage *cpack = NULL;

    if (len > 0) {
        cpackres = (commPackageResponse *) msg;
        cpack = new commPackage();
        cpack->tc = (command) cpackres->tc;
        switch (cpack->tc) {
            case OPEN:
                cpack->newhnd = cpackres->hnd;
                break;
            case CLOSE:
                cpack->ack = cpackres->ack;
                break;
            case MESSAGE:
                break;
            case LOAD:
                break;
            case UNLOAD:
                break;
            case MODULE_QTY:
                cpack->cant = cpackres->cant;
                break;
            case MODULE_NAME:
                for (int i=0 ; i < MAX_LEN_NAME ; i++) {
                    cpack->mod[i] = cpackres->mod[i];
                };
                break;
            case INIT:
                break;
            case CONFIGURE:
                break;
            case NOTHING:
                break;
        }
    }
    return cpack;
}
